<?php

namespace App\Http\Api;

use App\Http\Services\CustomerService;
use App\Http\Requests\UserRequest;
use Illuminate\Http\Request;

class CustomerController{

    private $customerService;

    private const STATUS = 400;

    function __construct(){
        $this->customerService = new CustomerService("CUSTOMER");
    }

    function index(){
        $users = $this->customerService->findAll();
        return response()->json($users);
    }

    function findAll(){
        $users = $this->customerService->findAuthCreated();
        return response()->json($users);
    }

    function store(UserRequest $request){
        return $this->customerService->save($request);
    }

    function update(UserRequest $request, $id){
        return $this->customerService->update($request, $id);
    }

    function delete($id){
        return $this->customerService->delete($id);
    }
}
