<?php

namespace App\Http\Api;

use App\Http\Services\UserService;
use App\Http\Requests\UserRequest;
use Illuminate\Http\Request;
use Exception;

class SellerController{

    private $userService;

    private const STATUS = 400;

    function __construct(){
        $this->userService = new UserService("SELLER");
    }

    function index(){
        $users = $this->userService->findAll();
        return response()->json($users);
    }

    function store(UserRequest $request){
        return $this->userService->save($request);
    }

    function update(UserRequest $request, $id){
        return $this->userService->update($request, $id);
    }

    function delete($id){
        return $this->userService->delete($id);
    }
}
