<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SellerProtectedRoute
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        try{
            $user = auth('api')->user();
            if($user->type != "SELLER") return response()->json(["error" => "User not seller"]);
        }catch(Exception $e){
            return response()->json(["error" => "User not authentication"]);
        }   

        return $next($request);
    }
}
