<?php

namespace App\Http\Services;

use App\Models\Customer;
use App\Models\User;
use Exception;

class CustomerService{
    private $type;
    private const STATUS = 400;

    function __construct($type){
        $this->type = $type;
    }

    public function findAll(){
        return User::where('type', $this->type)->paginate();
    }

    public function save($request){
        try{
            $data =  $request->all();
           
            $user =  User::updateOrCreate(['email' => $data['phone']], [
                'password' => bcrypt($data['password']),
                'email' => $data['phone'],
                'name' => $data['name'],
                'type' => $this->type,
                'created_by' => auth('api')->user()->id ?? null
            ]);
            
            Customer::updateOrCreate(['email' => $data['phone']], [
                'password' => bcrypt($data['password']),
                'celular' => $data['phone'],
                'name' => $data['name'],
            ]);
            
            return response()->json($user);
        }catch(Exception $e){
            return response()->json(["error" => $e->getMessage()], static::STATUS);
        }
    }

    public function findAuthCreated(){
        try{
            $user_id = auth()->user()->id ?? null;
            return User::where(['type', $this->type, 'created_by' => $user_id])->paginate();
        }catch(Exception $e){
            return response()->json(['error' => 'auth not found']);
        }
    }

    public function update($request, $id){
        try{
            if(!User::where('id',$id)->exists()) return response()->json(["error" => "Not found by ID"]);
            $data =  $request->all();
            $user = User::find($id);
            $user->update(['email' => $data['phone'],'name' => $data['name'],]);
            return response()->json($user);
        }catch(Exception $e){
            return response()->json(["error" => $e->getMessage()], static::STATUS);
        }
    }

    public function delete($id){
        try{
            if(!User::where('id',$id)->exists()) return response()->json(["error" => "Not found by ID"]);
            $user = User::find($id);
            $user->delete();
            return response()->json([]);
        }catch(Exception $e){
            return response()->json(["error" => $e->getMessage()], static::STATUS);
        }
    }

}
